 ; Ŀ
 ;   Dart - derotate all blocks of one type.                               
 ;   Copyright 2002 by Rocket Software Ltd.                                
 ;                                                                         
 ; 

 ; Ŀ
 ;   Subroutine Sqib: derotate an entity.                                  
 ;   Argument: Enam, an entity name.                                       
 ;   Calls nothing, Returns nothing. Snores.                               
 ; 
 (DEFUN SQIB (enam / entt ra pa rotang)
  (setq entt (entget enam))
  (if (setq ra (cdr (assoc 50 entt)))
      (progn
           (setq pa (cdr (assoc 10 entt)))
           (setq rotang (- (/ (* 180 ra) pi)))
           (command ".rotate" enam "" pa rotang)))
 (princ))
 ; Ŀ
 ;   Subroutine Sqib end.                                                  
 ; 

 ; Ŀ
 ;   Dart.                                                                 
 ; 
 (DEFUN C:DART ( / goon hi num bl ss rad enam namm pa)
  (setvar "cmdecho" 0)
  (command "undo" "begin")
  (setq namm (getstring "Name of blocks to derotate or <Return> to select an example: "))
  (if (= namm "")
      (progn
           (setq namm (entsel "Select a block: "))
           (while (null goon)
                  (cond ((null namm)
                         (setq namm (entsel "\nHave another shot: ")))
                        ((not (setq namm (cdr (assoc 2 (setq entt
                                                       (entget (car namm)))))))
                         (setq namm (entsel "\nThat wasn't a block: ")))
                        (T
                         (setq goon T))))))
  (setq namm (strcat (strcase (substr namm 1 1)) (strcase (substr namm 2) t)))
  (setq ss (ssget "X" (list (cons 2 namm))))
  (if ss
     (progn
          (setq rad (/ (getvar "viewsize") 25))
          (prompt (strcat "\n" namm " inserts found: " (itoa (sslength ss))))
          (setq num 0)
          (while (setq enam (ssname ss num))
                 (setq num (1+ num))
                 (setq pa (cdr (assoc 10 (entget enam))))
                 (grdraw (polar pa (/ pi 4) rad)
                         (polar pa (* 1.25 pi) rad) 7)
                 (grdraw (polar pa (* pi 0.75) rad)
                         (polar pa (* pi 1.75) rad) 7)
                 (sqib enam)))
    (write-line (strcat "\nNo " nammc " insertions found. ")))
  (command "undo" "end")
 (princ))